Attribute VB_Name = "RealTimer"
' RealTimer project

' File:           RealTimer.bas
' Author:      Colupaika at OpenScience Ltd
' Version:  2.0
' Developed under VB 5.0

' Distributed under GNU GPL v 2

'This file includes the most of procedures for RealTimer
'including graphical output to the RealTimer form

'This product includes software developed by vbAccelerator (http://vbaccelerator.com/)
'(see cCustomClipboard and cScrollBars classes)

Option Explicit


Type KeyType
    code As Integer
    Name As String * 20
    comment As String * 40
    Duration As Byte
    Toggle As Byte
    StopOtherToggles As Byte
    DownTime As Double
    state As Byte
    togglestate As Byte
End Type
   
Public Const RT_Data_EXE = "RT_DATA.EXE"
Public Const RT_Logo = "RT_LOGO.GIF"

Type CmdPanelType
    x As Integer
    y As Integer
    hl As Byte
    SkinX As Integer
    SkinY As Integer
End Type

Public cButton(0 To NumCmd) As CmdPanelType

'Public ButtonHL(0 To NumCmd) As Byte
'Public ButtonX(0 To NumCmd) As Integer
'Public ButtonY(0 To NumCmd) As Integer
'Public ButtonSkin(0 To NumCmd) As Integer

'  LittleWindow

Const BasicSizeX = 5175
Const BasicSizeY = 4200
Const BasicSizeY2 = 4680

Public NumKeys As Integer '  
Public key() As KeyType  '  
Public WindowLeft As Single
Public WindowTop As Single
Public CommentsWindowLeft As Single
Public CommentsWindowTop As Single
Public OptionsWindowLeft As Single
Public OptionsWindowTop As Single
Public PresetsWindowLeft As Single
Public PresetsWindowTop As Single
Public KeysWindowLeft As Single
Public KeysWindowTop As Single

Public RealTimerNoHelp As Byte
Public VideoPanel As Byte
Public EnterOnStart As Byte ' Enter   
Public VideoAutoStart As Byte '  
Public UseSpaceForVideo As Byte '    
Public KeysOnScreen As Byte '    
Public KeysOnScroll As Byte '     Scroll Lock
Public RegAllKeys As Byte '  - ,     

Public WindowSize As Byte
Public LastOptions As Byte
Public TimerActive As Boolean

Dim Rec() As String   ' -    
Dim NumRec As Long ' 

Dim SavedFile() As String '     
Dim NumSavedFiles As Integer '  

Dim ret As Long
Public DebugMode As Boolean
Public CommInput As Boolean ' 

Dim comments As String ' 
Dim DownTime As Double '  
Dim UpTime As Double '  
Dim Duration As Double '  
Dim LongDuration As Double '  
Dim CurrentKey As Integer        '   ()  c
Dim CurrentRec As String '           
Public ExitTime As Double '   (  Esc)

Dim TimeText As String
Dim DurationText As String

Public EpisodeComments As String ',    
'Public AskForEpisodeComments As Byte '    

Public StartTime As Single '   (  0)
Public WorkMode As Integer ' : 0= , 1=
Public NotSaved As Boolean '  
Public Pause As Boolean '  -    
Public ScreenTimerPrecision As Byte '   : 0 -    

Public BigWindowLoaded As Boolean
Public LittleWindowLoaded As Boolean
Public LittleWindowTitle As String

Public RecLimited As Boolean '    ,  
Public RecStopped As Boolean '    ,  

Public TimeReset As Boolean '   -   
Public NumEvents As Long '      

Public PressAnyKey As Boolean '    

Public LastCommText() As String '   
Public NumlastComm As Integer


Sub Initialize()
Language = "ru"
LanguageFile = "RealTimer_ru.lng"
Pause = True
ReadINI
SetButtonNames
WorkMode = 0 '2
ReDim Rec(1 To 100) As String
ReDim key(1 To 1) As KeyType
ResetKeyboard
Load LittleWindow
GetVideoStatus
' Scroll Lock    - 
ret = GetKeyState(VK_SCROLL)
If ret <> 0 Then ScrollLock

'   
'While Pause = True
'    DoEvents
'Wend

'Unload Logo
End Sub

Sub BigWindow_Hide()
        BigWindow.WindowState = 0
        BigWindow.Width = Screen.Width
        BigWindow.Height = 10
        BigWindow.Top = 0
        BigWindow.Left = 0
End Sub

Sub BigWindow_Show()
        BigWindow.WindowState = 2
        BigWindow.ShowCommandsInfo
        'BigWindow.Width = Screen.Width
        'BigWindow.Height = 10
        'BigWindow.top = 0
        'BigWindow.left = 0
End Sub

Sub RealTimer_Main()
    Load BigWindow
    If ShowBigWindow = 0 Then
        BigWindow_Hide
    End If
    BigWindow.Show 0

If ShowBigWindow = 1 Then BigWindow.ShowCommandsInfo

Pause = True
cmd = 0
NumEvents = 0

Do
    If AskForPreset = 1 Then ChoosePreset.Show 1
    If cmd = -1 Then
        Unload BigWindow
        StartForm.RestoreStartForm
        Exit Sub
    End If
    cmd = 11
    If AskForComments = 1 Then InputComments.Show 1
    If cmd = 11 Then Exit Do
Loop


If ShowBigWindow = 1 Then BigWindow.ShowCommandsInfo

    cmd = 0
    MakeAdditionalKeys
    ResetAllKeys
    If RealTimerNoHelp = 0 And ShowBigWindow = 1 Then
        BigWindow.HelpWindow.Visible = True
        BigWindow.HelpWindow.Enabled = True
    End If
    LittleWindow.Show 0
    ResizeLittleWindow CInt(WindowSize)
    Pause = False
    If EnterOnStart = 1 Then
        LittleWindow.StartPressAnyKey
    Else
        LittleWindow.StopPressAnyKey
    End If
    'Do
    '    DoEvents
    '    SleepEx 50, 1
    '    Select Case cmd
    '    Case -1: Exit Do
    '    End Select
    'Loop
'Pause = True
'LittleWindow.Hide
'Unload BigWindow
End Sub

Sub Finish()
Unload LittleWindow
End Sub

Sub AddEpisodeComments()
    Dim buf As String
    If Player = 1 Then buf = CStr(CLng(StartTime * 100) / 100) Else buf = ""
    AddAuxRec "Reset", buf, EpisodeComments
End Sub

Sub ResetKeyboard()
   Dim ret As Integer
   Dim KeyCode As Integer
   For KeyCode = 1 To 255
        ret = GetAsyncKeyState(KeyCode)
   Next KeyCode
End Sub


Sub ResizeLittleWindow(size_index As Integer)
Dim x As Integer
Dim y As Integer

Select Case size_index
Case 1
    x = BasicSizeX
    If VideoPanel = 1 Then
        y = BasicSizeY2
    Else
        y = BasicSizeY
    End If
Case 2
    x = BasicSizeX * 1.9
    y = BasicSizeY * 2
Case 3
    x = BasicSizeX * 1.9
    If VideoPanel = 1 Then
        y = BasicSizeY2
    Else
        y = BasicSizeY
    End If
Case 4
    x = BasicSizeX * 1.9
    y = BasicSizeY * 1.5
Case 5
    x = Screen.Width - BasicSizeX
    If x > BasicSizeX * 1.5 Then y = 2000 Else y = 3000
End Select
LittleWindow.Width = x
LittleWindow.Height = y

PositionForm LittleWindow
End Sub

Sub StopKeys()

Dim k As Integer

For k = 1 To NumAdditionalKeys
        If key(k).state = 1 Then
            KeyOff k
        End If
Next k

End Sub

Sub ShowPlanTimer()
       
        LittleWindow.KeyTimer.Enabled = False
        TestKey 27
        TestKey 120 'F9
        PlanTimer.Show 1
        ResetAllKeys
        LittleWindow.KeyTimer.Enabled = True
End Sub

Sub ProcessKeys()
Dim k As Integer
Dim t As Long
Dim alt As Long
'Functional keys
If App.Title = "Closing RealTimer" Then Exit Sub

If CommInput = True Then Exit Sub

If StartForm.WindowState = vbMinimized Then
    'alt = GetKeyState(&H12) And -128
    If TestKey(120) And PlanTimerVisible = False Then
        ShowPlanTimer
    End If
End If

'ESC - new exp
ret = GetKeyState(27)
If (ret And 32768) <> 0 And Pause = False Then
    '0 reset time
    ExitTime = GetCurrentTime
    LittleWindow.ButtonUP cmdNewExp
End If

'  -     
If Pause = True Then
    Exit Sub
End If

'If Player = 1 Then GetVideoStatus

If PressAnyKey = True Then
    'Enter
    ret = GetKeyState(13)
    If (ret And 32768) Then
            PressAnyKey = False
            LittleWindow.StopPressAnyKey
            ResetKeyboard
    End If
    Exit Sub
End If

'If alt Then
'Alt, comments input
'processed by the form
'Else
'normal events input

    'User keys
    For k = 1 To NumKeys
        ProcessOneKey k
    Next k

If RegAllKeys = 1 Then
    'additional alfabet keys
    For k = NumKeys + 1 To NumAdditionalKeys
        ProcessOneKey k
    Next k
End If

End Sub

Sub ResetAllKeys()
Dim k As Integer
Dim ret As Long
For k = 1 To NumAdditionalKeys
   ret = GetKeyState(key(k).code)
Next k
End Sub

Sub ProcessOneKey(k As Integer)
Dim i As Integer
Dim ret As Long
   'Read the key status
   ret = GetAsyncKeyState(key(k).code)
    'if down now
   If ret And -32768 Then
        If key(k).state = 0 Then
            ' 
            key(k).DownTime = GetCurrentTime
            key(k).state = 1
            If KeysOnScreen = 1 Then LittleWindow.KeyMarker.Visible = True
            If k <= NumKeys And KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyPress k, 1
            If KeysOnScroll = 1 Then ScrollLock
        '----
        End If
   End If
   
    If ret = 0 And key(k).state = 1 Then
        ' 
        KeyOff k
    End If
        
   'End If
 'End If

'Debug.Print key(k).Name
End Sub

Sub KeyOff(k As Integer)
            Dim i As Integer
            key(k).state = 0
            DownTime = key(k).DownTime
            UpTime = GetCurrentTime
            LittleWindow.KeyMarker.Visible = False
            If k <= NumKeys And KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyPress k, 0
            If KeysOnScroll = 1 Then ScrollLock
            If key(k).Duration = 1 Then Duration = UpTime - DownTime Else Duration = 0
            'If k <= NumKeys Then BigWindow.ShowKeyState k, key(k).state
           
            'Toggles
            If key(k).Toggle = 1 Then
                key(k).togglestate = Abs(key(k).togglestate - 1)
                If key(k).togglestate = 1 Then
                    'TOGGLE OFF
                    If key(k).StopOtherToggles = 1 Then
                        'stop other toggles
                        For i = 1 To NumKeys
                            If i <> k And key(i).Toggle = 1 And key(i).togglestate = 1 Then
                                        key(i).togglestate = 0
                                        CurrentKey = i
        
                                        MakeCurrentRec 0
                                        AddKey_Mem
                                        AddKey_Screen
                                    If KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyState i, key(i).togglestate
                            End If
                        Next i
                    End If
                End If
                If k <= NumKeys And KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyState k, key(k).togglestate
            End If
        
       
        CurrentKey = k
        MakeCurrentRec 0
        AddKey_Mem
        AddKey_Screen
End Sub

Sub AddKey_Mem()
Dim size As Long
NumRec = NumRec + 1
If NumRec > UBound(Rec) Then
    size = UBound(Rec) + 100
    ReDim Preserve Rec(1 To size) As String
End If
Rec(NumRec) = CurrentRec
End Sub

    'This function returns a word from text with SPACE delimiters
Public Function Word$(text$, num)
    Dim k As Integer
    Dim oldk As Integer
    Dim t As Integer
    Dim i As Integer
    Dim w As String
    k = 0
    oldk = 1
    For t = 1 To num
    k = InStr(oldk + 1, text$, " ")
    i = k + 1
    While Mid$(text$, i, 1) = " ": i = i + 1: Wend
    If k = 0 Then k = Len(text$) + 1: i = k
    If k > oldk Then w$ = Mid$(text$, oldk, k - oldk) Else w$ = ""
    oldk = i
    Next t
    Word$ = w$
End Function

'This function returns a word from text with TAB delimiters
Public Function Word9$(text$, num)
    Dim k As Integer
    Dim l As Integer
    Dim oldk As Integer
    Dim i As Integer
    Dim w As String
    Dim t As Integer
    
    k = 0
    l = Len(text$)
    oldk = 1
    For t = 1 To num
    k = InStr(oldk, text$, Chr(9))
    i = k
    'While Mid$(text$, i, 1) = Chr(9): i = i + 1: Wend
    If k = 0 Then k = l + 1
    If k > oldk Then w$ = Mid$(text$, oldk, k - oldk) Else w$ = ""
    oldk = i + 1
    If k > l And t < num Then w$ = "": Exit For
    Next t
    If Left(w$, 1) = Chr(9) Then Mid(w$, 1, 1) = " "
    Word9$ = w$
End Function

Sub DeleteRec(num As Long)
    Dim t As Long
    If NumRec = 0 Then Exit Sub
    If num = 0 Then Exit Sub
    If num = NumRec Then
        'correction of last on/off event
        DeleteRecOnOff num
    End If

    For t = num + 1 To NumRec
        Rec(t - 1) = Rec(t)
    Next t
    NumRec = NumRec - 1
    
    With LittleWindow.EventTable
        If num > 0 And num <= .ListCount Then .RemoveItem (num - 1)
        If num <= .ListCount Then .ListIndex = num - 1
    End With

End Sub

Sub DeleteRecOnOff(num As Long)
    Dim buf As String
    Dim buf2 As String
    Dim k As Integer
    buf = Word9(Rec(num), 4)
    If buf = "ON" Or buf = "OFF" Then
        buf2 = Word9(Rec(num), 1)
        For k = 1 To NumKeys
            If buf2 = Btn(key(k).code) Then
                If buf = "OFF" Then key(k).togglestate = 1 Else key(k).togglestate = 0
                If KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyState k, key(k).togglestate
            End If
        Next k
    End If
End Sub

Sub AddKey_Screen()
    'Dim itmX As ListItem
    'Set itmX = LittleWindow.EventTable.ListItems.Add(, , ButtonName(key(CurrentKey).code))
    'itmX.SubItems(1) = RTrim(NulTrim(key(CurrentKey).Name))
    'itmX.SubItems(2) = DotValue(CSng(DownTime))
    'itmX.SubItems(3) = DurationText
    'itmX.SubItems(4) = TimeText
    
    'itmX.EnsureVisible = True
    'itmX.Ghosted = True
    
    'LittleWindow.EventTable.SelectedItem = itmX
    
    'LittleWindow.EventTable.refresh
    
    LittleWindow.EventTable.AddItem CurrentRec
    LittleWindow.EventTable.ListIndex = LittleWindow.EventTable.ListCount - 1
End Sub


Sub MakeCurrentRec(code As Integer)

NumEvents = NumEvents + 1

DurationText = ""
If code = 0 Then
    CurrentRec = Btn(key(CurrentKey).code)
    CurrentRec = CurrentRec + vbTab + RTrim(NulTrim(key(CurrentKey).Name))
Else
    CurrentRec = Btn(code)
    CurrentRec = CurrentRec + vbTab + "KEY"
End If
CurrentRec = CurrentRec + vbTab + DotValue(CSng(DownTime))

If key(CurrentKey).Toggle = 1 Then
    If key(CurrentKey).togglestate > 0 Then
        DurationText = "ON"
    Else
        DurationText = "OFF"
    End If
    CurrentRec = CurrentRec + vbTab + DurationText
ElseIf key(CurrentKey).Duration = 1 Then
    DurationText = DotValue(CSng(Duration))
    CurrentRec = CurrentRec + vbTab + DurationText
Else
    CurrentRec = CurrentRec + vbTab + " "
End If

TimeText = TimeFormat(CSng(DownTime))
CurrentRec = CurrentRec + vbTab + TimeText
NotSaved = True
End Sub

Sub AddAuxRec(Name As String, Value As String, comments As String)
'  
 CurrentRec = Name + vbTab + vbTab + Value + vbTab + vbTab + comments
 AddKey_Mem
 AddKey_Screen
End Sub

Function GetCurrentTime()
Select Case WorkMode
Case 1
    GetCurrentTime = CLng((vi.pos / 1000 - StartTime) * 100) / 100
Case Else
    GetCurrentTime = CLng((Timer - StartTime) * 100) / 100
End Select
End Function

Sub MeasureStart()
Dim buf As String
Dim k As Integer
'  
AddExitRec
    
Select Case WorkMode
Case 1
    StartTime = (vi.pos) / 1000
Case Else
    StartTime = Timer
End Select
Pause = False
RecLimited = False
RecStopped = False
'  
For k = 1 To NumKeys
        If key(k).Toggle = 1 Then
            key(k).togglestate = 0
            If KeysOnScreen = 1 And BigWindowLoaded = True Then BigWindow.ShowKeyState k, 0
        End If
Next k
NumEvents = 0
If TimerActive = False Then
    LittleWindow.TimeLabel_Click
End If
LittleWindow.KeyTimer.Enabled = True
LittleWindow.CheckTimer.Enabled = True
End Sub

Sub WriteFile_OldFormat(FileName As String)
Dim i As Long
Dim fx As Integer
Dim buf As String
fx = FreeFile
Open FileName For Output As #fx
'header
Print #fx, "<header>"
Print #fx, "RTComments=" + comments
Print #fx, "DataPeriod=10000"
Print #fx, "TimeMeasure=c"
Print #fx, "</header>"
Print #fx, "<table>"
'table
Dim Header As String
Header = "key" + Chr(9) + "event" + Chr(9) + "time" + Chr(9) + "dur"
If WorkMode = 1 Then Header = Header + Chr(9) + "time2"
If WorkMode = 0 Then Header = Header + Chr(9) + "tmofday"
Print #fx, Header
For i = 1 To NumRec
    buf = Rec(i)
    ANSI2ASCII buf
    Print #fx, buf
Next i
Close #fx
End Sub


Function DotValue(Value As Single) As String
'     -       
Dim buf As String
buf = LTrim(Str(Value))
If Left(buf, 1) = "." Then buf = "0" + buf
If Left(buf, 2) = "-." Then buf = "-0" + Mid(buf, 2)
DotValue = buf
End Function

Sub CheckFileName(buf As String)
Dim i As Integer
    For i = 1 To Len(buf)
        If Mid(buf, i, 1) = "?" Then Mid(buf, i, 1) = "-"
        If Mid(buf, i, 1) = "/" Then Mid(buf, i, 1) = "-"
        If Mid(buf, i, 1) = "." Then Mid(buf, i, 1) = "_"
    Next i
End Sub

Sub SaveFile()

Dim FileName As String
Dim i As Integer
Dim res As Long
Dim buf As String
Dim buf3 As String
Dim path As String

'Getting free file name
    
buf = Date

CheckFileName buf

i = 0
path = CorrectPath(ResultsPath)
Do
    i = i + 1
    buf3 = LTrim(Str(i))
    If Len(buf3) < 2 Then buf3 = "0" + buf3
    If Len(buf3) < 3 Then buf3 = "0" + buf3
    FileName = Dir(path + buf + "_" + buf3 + ".txt")
Loop Until FileName = ""

FileName = buf + "_" + buf3
        
Do
        FStr.hWndOwner = LittleWindow.hWnd
        FStr.hInstance = App.hInstance
        FStr.lpstrFilter = "Text table (*.txt)" + Chr$(0) + "*.txt" + Chr$(0) + "  (*.*)" + Chr$(0) + "*.*" + Chr$(0) + Chr$(0)
        FStr.nFilterIndex = 1
        FStr.lpstrFileTitle = String(257, 0)
        FStr.nMaxFileTitle = Len(FStr.lpstrFileTitle) - 1
        FStr.lpstrInitialDir = ResultsPath
        FStr.lpstrTitle = " "
        FStr.flags = OFN_NOCHANGEDIR Or OFN_HIDEREADONLY Or OFN_EXPLORER
        FStr.FileName = FileName + String(257, 0)
        FStr.nMaxFile = Len(FStr.FileName) - 1
        FStr.lStructSize = Len(FStr)
        res = GetSaveFileName(FStr)
        If res = 0 Then Exit Do
        ResultsPath = XFilePath(FStr.FileName)
        FileName = NulTrim(FStr.FileName)
        If InStr(LCase(FileName), ".txt") = 0 Then FileName = RTrim(FileName) + ".txt"
        
    ret = 1
    If Dir(FileName) <> "" Then
        ret = AskQuestion(GetRString("c_QuestionOverwrite", "     ?") + vbCrLf + XFileName(FileName), 2)
    End If
        
    If ret = 1 Then
            '     - 
            ResultsPath = XFilePath(FileName)
            SetIniPath
            IniFile$ = IniPath$ + IniFileName
            WritePrivateProfileString "Common", "ResultsPath", ResultsPath, IniFile$
        
            WriteFile_OldFormat FileName
            NumSavedFiles = NumSavedFiles + 1
            ReDim Preserve SavedFile(1 To NumSavedFiles) As String
            SavedFile(NumSavedFiles) = XFileName(FileName)
            ShortMessage GetRString("Saved", ""), ""
            NotSaved = False
            Exit Do
    End If
Loop

End Sub

Sub AddExitRec()
If NumEvents > 0 And ExitTime > 0 Then
    AddAuxRec "Exit", LTrim(Str(ExitTime)), ""
    ExitTime = 0
    NumEvents = 0
End If
End Sub

Function CheckNotSaved()
'check wheher results are not saved
Dim ret As Long
Do
If NotSaved = True And NumRec > 0 Then
    ret = AskQuestion(GetRString("c_AreYouSure_SaveData", "   .") + _
        vbCrLf + GetRString("c_AreYouSure_SaveData2", " ?"), 1)
    If ret = 1 Then
        SaveFile
    End If
    If ret = 2 Or ret = -1 Then Exit Do
Else
    Exit Do
End If
Loop
CheckNotSaved = ret
End Function

Sub ClearRecords()
NumRec = 0
LittleWindow.EventTable.Clear
DoEvents
End Sub

Function GetTimeHMS() As String
'returns current time from start in hh:mm:ss format
Dim tm As Single
GetTimeHMS = TimeFormat(CSng(GetCurrentTime))
End Function


'Load all key file names to the listbox 'Lst'
Public Sub RefreshPresetList(Lst As Control)
Dim buf As String
Dim Title As String
Dim path As String
Dim Index As Integer
Dim FileName() As String
Dim i As Integer, k As Integer, s As Integer
ReDim FileName(1 To 20) As String

'index = PresetList.ListIndex
Lst.Clear

CheckPath KeyPath
buf = Dir(CorrectPath(KeyPath) + "*.key")
While buf <> ""
    i = i + 1
    If i > UBound(FileName) Then ReDim Preserve FileName(1 To i) As String
    FileName(i) = XName(buf)
    buf = Dir
Wend

'alfabit sort
For k = 1 To i
    For s = k + 1 To i
        If FileName(k) > FileName(s) Then
            buf = FileName(k)
            FileName(k) = FileName(s)
            FileName(s) = buf
        End If
    Next s
Next k

'searching for current position
buf = LCase(RTrim(XName(XFileName(KeyFileName))))
For k = 1 To i
    Lst.AddItem FileName(k)
    If buf <> "" And buf = LCase(XName(FileName(k))) Then
        Lst.ListIndex = Lst.ListCount - 1
    End If
Next k

'If Lst.ListIndex = -1 And index < Lst.ListCount Then Lst.ListIndex = index
End Sub

Function MakeCmdLine_for_RT_Tables() As String
Dim i As Integer
Dim cmdLine As String
    
    If NumSavedFiles > 0 Then
        'If NumSavedFiles > 1 Then
        '    cmdLine = ResultsPath + " "
        'Else
        '    cmdLine = CorrectPath(ResultsPath)
        'End If
        '   !!!
        For i = 1 To NumSavedFiles
            cmdLine = cmdLine + Chr(34) + SavedFile(i) + Chr(34) + " "
        Next i
    End If

MakeCmdLine_for_RT_Tables = cmdLine
End Function

