Attribute VB_Name = "General"
' RealTimer project

' File:           General.bas
' Author:      Colupaika at OpenScience Ltd
' Modif date: 08 - 2008
' Version:  2.0
' Developed under VB 5.0

' Distributed under GNU GPL v 2

'This module includes declarations for several API functions used within the project
'This module includes unsorted functions

Declare Function SleepEx Lib "kernel32" (ByVal dwMilliseconds As Long, ByVal bAlertable As Long) As Long
Declare Function SetWindowPos Lib "USER32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Declare Function SetActiveWindow Lib "USER32" (ByVal hWnd As Long) As Long
Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Declare Function ShowWindow Lib "USER32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
Declare Function FindWindow Lib "USER32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Declare Function SetForegroundWindow Lib "USER32" (ByVal hWnd As Long) As Long
Declare Function GetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long) As Long
Declare Function ReleaseDC Lib "USER32" (ByVal hWnd As Long, ByVal hdc As Long) As Long

Declare Function GetWindowPlacement Lib "USER32" (ByVal hWnd As Long, lpwndpl As WINDOWPLACEMENT) As Long
Declare Function SetWindowPlacement Lib "USER32" (ByVal hWnd As Long, lpwndpl As WINDOWPLACEMENT) As Long

Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Type WINDOWPLACEMENT
        Length As Long
        flags As Long
        showCmd As Long
        ptMinPosition As POINTAPI
        ptMaxPosition As POINTAPI
        rcNormalPosition As RECT
End Type

Public Const SWP_NOMOVE = 2
Public Const SWP_NOSIZE = 1
Public Const flags = SWP_NOMOVE Or SWP_NOSIZE
Public Const HWND_TOPMOST = -1
Public Const HWND_NOTOPMOST = -2

' ShowWindow() Commands
Public Const SW_HIDE = 0
Public Const SW_SHOWNORMAL = 1
Public Const SW_NORMAL = 1
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_MAXIMIZE = 3
Public Const SW_SHOWNOACTIVATE = 4
Public Const SW_SHOW = 5
Public Const SW_MINIMIZE = 6
Public Const SW_SHOWMINNOACTIVE = 7
Public Const SW_SHOWNA = 8
Public Const SW_RESTORE = 9
Public Const SW_SHOWDEFAULT = 10
Public Const SW_MAX = 10

' 

Public Const NumCmd = 21


Public Const cmdOpen = 0
Public Const cmdPlay = 1
Public Const cmdPause = 2
Public Const cmdPREVFRAME = 4
Public Const cmdNEXTFRAME = 3
Public Const cmdStop = 5
Public Const cmdKeys = 6
Public Const cmdClear = 7
Public Const cmdSave = 8
Public Const cmdClose = 9
Public Const cmdNewExp = 10
Public Const cmdBrowse = 11
Public Const cmdVideo = 12
Public Const cmdSLOWER = 13
Public Const cmdPlanTmr = 14
Public Const cmdOPTIONS = 15
Public Const cmdRat = 16
Public Const cmdHelp = 17
Public Const cmdMinimize = 18
Public Const cmdTable = 19
Public Const cmdFASTER = 20
Public Const cmdCopy = 21
Public Const cmdPlanTable = 23
    '23 is also occupied

Public MessageTime As Single '   

'ControlMove values
Dim x0 As Single
Dim y0 As Single
Dim WindowMove As Boolean

Public ResultsPath As String
Public KeyPath As String
Public TimerPath As String
Public SkinFile As String

Public Const IniFileName = "RealTimer.INI"
Public Const Plan_IniFileName = "PlanTimer.INI"

Public cmd As Integer ' 

Function AskQuestion(text As String, default As Integer)
    Load Question
    Question.QuestionLabel.Caption = text
    cmd = 0
    If default = 1 Then Question.cmdYes.tag = "1"
    If default = 2 Then Question.cmdNo.tag = "1"
    Question.Show 1
    AskQuestion = cmd
    cmd = 0
End Function

Sub PositionForm(frm As Form)
'   ,        
' ,         

'   !!!

If frm.Left + frm.Width > Screen.Width Then frm.Left = Screen.Width - frm.Width
If frm.Top + frm.Height > Screen.Height Then frm.Top = Screen.Height - frm.Height

End Sub

Public Sub ControlMouseDown(x As Single, y As Single)
x0 = x
y0 = y
WindowMove = True
End Sub

Public Sub ControlMouseUp()
WindowMove = False
End Sub

Public Sub ControlMove(c As Control, x As Single, y As Single)
If WindowMove = True Then
    c.Left = c.Left + (x - x0) / Screen.TwipsPerPixelX
    c.Top = c.Top + (y - y0) / Screen.TwipsPerPixelY
    DoEvents
End If
End Sub

Sub ShowMessage(text As String)
Dim ret As Long
Load Message
Message.MessageText.Caption = text
Message.Show 0
ret = SetWindowPos(LittleWindow.hWnd, HWND_TOPMOST, 0, 0, 0, 0, flags)
End Sub

Sub ShortMessage(text As String, Title As String)
    Load Message
    MessageTime = 0.7
    Message.MessageText.Caption = text
    If Title <> "" Then Message.MessageTitle.Caption = Title
    Message.Show 1
    Unload Message
End Sub

Function TestKey(KeyCode As Integer) As Boolean
   Dim ret As Integer
   ret = GetAsyncKeyState(KeyCode)
   If (ret And 1) Then
        Do
            DoEvents
            SleepEx 20, 1
        Loop Until (GetAsyncKeyState(KeyCode) And 1) = 0
        TestKey = True
    Else
        TestKey = False
    End If
End Function


Public Function TimeFormat(tm As Double) As String
Dim k As Long
Dim FTime As Double
Dim tl As Long
Dim buf As String
Dim sign As String
If tm < 0 Then sign = "- "
FTime = Abs(tm)
If Int(FTime) = 0 And ScreenTimerPrecision = 0 Then sign = ""
buf = ""
k = FTime \ 3600
tl = k: tl = tl * 3600
If k > 0 Then buf = buf + LTrim$(Str(k)) + ":": FTime = FTime - tl
k = FTime \ 60
If k < 10 Then buf = buf + "0"
If k > 0 Then
    buf = buf + LTrim$(Str(k))
    FTime = FTime - k * 60
End If
buf = buf + ":"
k = Int(FTime)
If k < 10 Then buf = buf + "0"
If k < 0 Then k = 0
buf = buf + LTrim$(Str(k))

If CLng(tm) <> tm And ScreenTimerPrecision > 0 Then
    FTime = CInt((FTime - k) * 100)
    If FTime >= 100 Then FTime = 99
    buf = buf + "."
    If FTime < 10 Then buf = buf + "0"
    buf = buf + LTrim$(Str$(FTime))
If Right(buf, 1) = "0" Then buf = Left(buf, Len(buf) - 1)
End If

TimeFormat = sign + buf
End Function

Public Function TimeFormatMs(tm As Double) As String
Dim k As Integer
Dim FTime As Double
Dim tl As Long
Dim buf As String
Dim sign As String
If tm < 0 Then sign = "- "
FTime = Abs(tm)
buf = ""
k = Int(FTime / 3600)
tl = k: tl = tl * 3600
If k > 0 Then buf = buf + LTrim$(Str(k)) + ":": FTime = FTime - tl
k = Int(FTime / 60)
If k < 10 Then buf = buf + "0"
If k > 0 Then
    buf = buf + LTrim$(Str(k))
    FTime = FTime - k * 60
End If
buf = buf + ":"
k = Int(FTime)
If k < 10 Then buf = buf + "0"
buf = buf + LTrim$(Str(k))

If CLng(tm) <> tm Then
    FTime = CInt((FTime - k) * 100)
    If FTime >= 100 Then FTime = 99
    buf = buf + "."
    If FTime < 10 Then buf = buf + "0"
    buf = buf + LTrim$(Str$(FTime))
If Right(buf, 1) = "0" Then buf = Left(buf, Len(buf) - 1)
End If
TimeFormatMs = sign + buf
End Function


