Attribute VB_Name = "INI_RealTimer"
' RealTimer project

' File:           INI_RealTimer.bas
' Author:      Colupaika at OpenScience Ltd
' Modif date: 03 - 2009
' Version:  2.0
' Distributed under GNU GPL v 2

'This module gets and saves preferences stored in RealTimer.ini file

Public AskForPreset As Byte 'Show list of presets at startup
Public AskForComments As Byte 'Show comments input at startup
Public LastKeyPreset As String 'Last key file name
Public DoNotShowClipInfo As Byte '     
Public ShowBigWindow As Byte '   

Public SoundLimit As Byte '  
Public SoundFileName As String '  -   
Public RecTimeLimit As Byte '  
Public LimitTime As Single ' 
Public LimitStopRec As Byte ' 

Sub SetIniPath()
Dim AppDataPath As String
'   - Application Data
AppDataPath = GetRegKey_String(HKEY_CURRENT_USER, "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\", "AppData")
IniPath = AppDataPath + "\RealTimer"
'    -  
If Dir(IniPath, vbDirectory) = "" Then
    MkDir IniPath
End If
IniPath = IniPath + "\"
End Sub

Sub SetMyDocPaths()
Dim MyDocPath As String

'   - Application Data
MyDocPath = GetRegKey_String(HKEY_CURRENT_USER, "Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\", "Personal")
MyDocPath = MyDocPath + "\RealTimer"
'    -  
' 
    If Dir(MyDocPath, vbDirectory) = "" Then
        MkDir MyDocPath
    End If
    
    If ResultsPath = "" Then ResultsPath = MyDocPath + "\Results"
    If Dir(ResultsPath, vbDirectory) = "" Then MkDir ResultsPath
    
    If KeyPath = "" Then KeyPath = MyDocPath + "\Keys"
    If Dir(KeyPath, vbDirectory) = "" Then
        MkDir KeyPath
        '  
        CopyFiles "*.key", KeyPath
    End If
    
    If TimerPath = "" Then TimerPath = MyDocPath + "\Timers"
    If Dir(TimerPath, vbDirectory) = "" Then
        MkDir TimerPath
        '  
        CopyFiles "*.tmr", TimerPath
    End If
End Sub

Public Sub ReadINI()
Dim i As Integer
Dim buf As String

' :    Ini  apppath,   .
'   ,   app.path (    )
SetIniPath
If Dir(CorrectPath(IniPath) + IniFileName) = "" Then
    IniFile$ = CorrectPath(App.path) + IniFileName
Else
    IniFile$ = IniPath$ + IniFileName
End If


Dim ret As String
        GetINIparam "Common", "VideoPlayerEXE", ret$, ""
        VideoPlayerEXE = ret
        GetINIparam "Common", "WindowLeft", ret$, "4000"
        WindowLeft = CSng(ret)
        GetINIparam "Common", "WindowTop", ret$, "4000"
        WindowTop = CSng(ret)
        
        GetINIparam "Common", "CommentsWindowLeft", ret$, "3000"
        CommentsWindowLeft = CSng(ret)
        GetINIparam "Common", "CommentsWindowTop", ret$, "3000"
        CommentsWindowTop = CSng(ret)
        
        GetINIparam "Common", "PresetsWindowLeft", ret$, "2000"
        PresetsWindowLeft = CSng(ret)
        GetINIparam "Common", "PresetsWindowTop", ret$, "2000"
        PresetsWindowTop = CSng(ret)
        
        GetINIparam "Common", "KeysWindowLeft", ret$, "2000"
        KeysWindowLeft = CSng(ret)
        GetINIparam "Common", "KeysWindowTop", ret$, "2000"
        KeysWindowTop = CSng(ret)
        
        GetINIparam "Common", "OptionsWindowLeft", ret$, "2000"
        OptionsWindowLeft = CSng(ret)
        GetINIparam "Common", "OptionsWindowTop", ret$, "2000"
        OptionsWindowTop = CSng(ret)
        
        
        GetINIparam "PlanTimer", "PlantimerWindowLeft", ret$, "1000"
        PlantimerWindowLeft = CSng(ret)
        GetINIparam "PlanTimer", "PlantimerWindowTop", ret$, "1000"
        PlantimerWindowTop = CSng(ret)
        GetINIparam "PlanTimer", "PlantimerNoHelp", ret$, "0"
        PlanTimerNoHelp = Val(ret)
        
        
        
        GetINIparam "Common", "RealtimerNoHelp", ret$, "0"
        RealTimerNoHelp = Val(ret)
                
        GetINIparam "Common", "VideoPanel", ret$, "0"
        VideoPanel = Val(ret)
        GetINIparam "Common", "WindowSize", ret$, "1"
        WindowSize = Val(ret)
        
        GetINIparam "Common", "LastOptions", ret$, "0"
        LastOptions = Val(ret)
                
                
        
        GetINIparam "Common", "LastKeyPreset", ret$, ""
        LastKeyPreset = ret
        If Dir(CorrectPath(KeyPath) + RTrim(LastKeyPreset) + ".key") = "" Then LastKeyPreset = ""
        
        GetINIparam "Common", "AskForPreset", ret$, "1"
        AskForPreset = Val(ret)
        GetINIparam "Common", "AskForComments", ret$, "1"
        AskForComments = Val(ret)
        GetINIparam "Common", "DoNotShowClipInfo", ret$, "0"
        DoNotShowClipInfo = Val(ret)
        GetINIparam "Common", "EnterOnStart", ret$, "1"
        EnterOnStart = Val(ret)
        GetINIparam "Common", "VideoAutoStart", ret$, "1"
        VideoAutoStart = Val(ret)
        GetINIparam "Common", "UseSpaceForVideo", ret$, "1"
        UseSpaceForVideo = Val(ret)
        GetINIparam "Common", "KeysOnScreen", ret$, "1"
        KeysOnScreen = Val(ret)
        GetINIparam "Common", "KeysOnScroll", ret$, "1"
        KeysOnScroll = Val(ret)
        GetINIparam "Common", "RegAllKeys", ret$, "1"
        RegAllKeys = Val(ret)
        
        GetINIparam "Common", "ShowBigWindow", ret$, "1"
        ShowBigWindow = Val(ret)
        
        GetINIparam "Common", "Skin", ret$, ""
        SkinFile = ret

'  
        GetINIparam "RecTimeLimit", "Limit", ret$, "0"
        RecTimeLimit = Val(ret)
        GetINIparam "RecTimeLimit", "LimitTime", ret$, "60"
        LimitTime = Val(ret)
        GetINIparam "RecTimeLimit", "SoundLimit", ret$, "0"
        SoundLimit = Val(ret)
        GetINIparam "RecTimeLimit", "SoundFileName", ret$, ""
        SoundFileName = ret
        GetINIparam "RecTimeLimit", "StopRec", ret$, "0"
        LimitStopRec = Val(ret)

'

SetMyDocPaths
IniFile$ = IniPath$ + IniFileName

'     
        GetINIparam "Common", "KeyPath", ret$, KeyPath
        KeyPath = ret
        GetINIparam "PlanTimer", "TimerPath", ret$, TimerPath
        TimerPath = ret
        GetINIparam "Common", "ResultsPath", ret$, ResultsPath
        ResultsPath = ret

End Sub

Public Sub SaveINI()
Dim i As Integer
Dim buf As String
On Local Error GoTo SaveIniErr
SetIniPath
IniFile$ = IniPath$ + IniFileName
    
    
WritePrivateProfileString "Common", "VideoPlayerEXE", VideoPlayerEXE, IniFile$
WritePrivateProfileString "Common", "WindowLeft", CStr(WindowLeft), IniFile$
WritePrivateProfileString "Common", "WindowTop", CStr(WindowTop), IniFile$
WritePrivateProfileString "Common", "CommentsWindowLeft", CStr(CommentsWindowLeft), IniFile$
WritePrivateProfileString "Common", "CommentsWindowTop", CStr(CommentsWindowTop), IniFile$
WritePrivateProfileString "Common", "PresetsWindowLeft", CStr(PresetsWindowLeft), IniFile$
WritePrivateProfileString "Common", "PresetsWindowTop", CStr(PresetsWindowTop), IniFile$
WritePrivateProfileString "Common", "KeysWindowLeft", CStr(KeysWindowLeft), IniFile$
WritePrivateProfileString "Common", "KeysWindowTop", CStr(KeysWindowTop), IniFile$
WritePrivateProfileString "Common", "OptionsWindowLeft", CStr(OptionsWindowLeft), IniFile$
WritePrivateProfileString "Common", "OptionsWindowTop", CStr(OptionsWindowTop), IniFile$

WritePrivateProfileString "PlanTimer", "PlanTimerWindowLeft", CStr(PlantimerWindowLeft), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerWindowTop", CStr(PlantimerWindowTop), IniFile$
WritePrivateProfileString "PlanTimer", "PlanTimerNoHelp", CStr(PlanTimerNoHelp), IniFile$

WritePrivateProfileString "Common", "RealTimerNoHelp", CStr(PlanTimerNoHelp), IniFile$
WritePrivateProfileString "Common", "VideoPanel", CStr(VideoPanel), IniFile$
WritePrivateProfileString "Common", "WindowSize", CStr(WindowSize), IniFile$
WritePrivateProfileString "Common", "LastOptions", CStr(LastOptions), IniFile$

WritePrivateProfileString "Common", "AskForPreset", CStr(AskForPreset), IniFile$
WritePrivateProfileString "Common", "AskForComments", CStr(AskForComments), IniFile$
WritePrivateProfileString "Common", "EnterOnStart", CStr(EnterOnStart), IniFile$

WritePrivateProfileString "Common", "VideoAutoStart", CStr(VideoAutoStart), IniFile$
WritePrivateProfileString "Common", "UseSpaceForVideo", CStr(UseSpaceForVideo), IniFile$
WritePrivateProfileString "Common", "KeysOnScreen", CStr(KeysOnScreen), IniFile$
WritePrivateProfileString "Common", "KeysOnScroll", CStr(KeysOnScroll), IniFile$
WritePrivateProfileString "Common", "RegAllKeys", CStr(RegAllKeys), IniFile$
WritePrivateProfileString "Common", "ShowBigWindow", CStr(ShowBigWindow), IniFile$

WritePrivateProfileString "PlanTimer", "TimerPath", TimerPath, IniFile$
WritePrivateProfileString "Common", "KeyPath", KeyPath, IniFile$
WritePrivateProfileString "Common", "ResultsPath", ResultsPath, IniFile$

WritePrivateProfileString "Common", "LastKeyPreset", XFileName(XName(KeyFileName)), IniFile$

'  
WritePrivateProfileString "RecTimeLimit", "Limit", CStr(RecTimeLimit), IniFile$
WritePrivateProfileString "RecTimeLimit", "LimitTime", CStr(LimitTime), IniFile$
WritePrivateProfileString "RecTimeLimit", "SoundLimit", CStr(SoundLimit), IniFile$
WritePrivateProfileString "RecTimeLimit", "SoundFileName", SoundFileName, IniFile$
WritePrivateProfileString "RecTimeLimit", "StopRec", CStr(LimitStopRec), IniFile$
SaveIniExit: Exit Sub
SaveIniErr:
    MsgBox "     " + IniFile
Resume SaveIniExit
End Sub

Public Sub SaveEmptyKeyInfo(keyfile As String, keynum As Integer)
Dim Header As String
Header = LTrim(Str(keynum))
If Len(Header) < 2 Then Header = "0" + Header
Header = "Key" + Header
WritePrivateProfileString Header, "code", "", keyfile
End Sub

Public Sub SaveKeyInfo(keyfile As String, keynum As Integer)
'      
Dim Header As String
Header = LTrim(Str(keynum))
If Len(Header) < 2 Then Header = "0" + Header
Header = "Key" + Header
WritePrivateProfileString Header, "code", LTrim(Str(key(keynum).code)), keyfile
WritePrivateProfileString Header, "name", RTrim(NulTrim(key(keynum).Name)), keyfile
WritePrivateProfileString Header, "comment", RTrim(NulTrim(key(keynum).comment)), keyfile
WritePrivateProfileString Header, "duration", LTrim(Str(key(keynum).Duration)), keyfile
WritePrivateProfileString Header, "toggle", LTrim(Str(key(keynum).Toggle)), keyfile
WritePrivateProfileString Header, "stopother", LTrim(Str(key(keynum).StopOtherToggles)), keyfile
End Sub

Public Function LoadKeyInfo(keyfile As String, keynum As Integer) As Integer
Dim Header As String
Dim ret As String
Header = LTrim(Str(keynum))
If Len(Header) < 2 Then Header = "0" + Header
Header = "Key" + Header
ret = String(255, 0)
GetPrivateProfileString Header, "code", "", ret, 255, keyfile
IniFile = keyfile
ret = NulTrim$(ret)
If ret <> "" Then
    LoadKeyInfo = 1
    NumKeys = keynum
    ReDim Preserve key(1 To keynum) As KeyType
    With key(keynum)
        .code = Val(ret)
        GetINIparam Header, "name", ret, ""
        .Name = ret
        GetINIparam Header, "comment", ret, ""
        .comment = ret
        GetINIparam Header, "duration", ret, ""
        .Duration = Val(ret)
        GetINIparam Header, "toggle", ret, ""
        .Toggle = Val(ret)
        GetINIparam Header, "stopother", ret, ""
        .StopOtherToggles = Val(ret)
    End With
Else
    LoadKeyInfo = 0
End If
'MakeAdditionalKeys
End Function

