Attribute VB_Name = "VideoMPC"
'Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

' File:           VideoMPC.bas
' Author:      Colupaika at OpenScience Ltd
' Version:  1.0
' Developed under VB 5.0

' Distributed under GNU GPL v 2

'This file contains procedures for diff video players interfaces

'This product includes software developed by vbAccelerator (http://vbaccelerator.com/)
'(see cCustomClipboard and cScrollBars classes)

Declare Function MultiByteToWideChar Lib "kernel32" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpMultiByteStr As String, ByVal cchMultiByte As Long, ByVal lpWideCharStr As String, ByVal cchWideChar As Long) As Long
Declare Function WideCharToMultiByte Lib "kernel32" (ByVal CodePage As Long, ByVal dwFlags As Long, ByVal lpWideCharStr As String, ByVal cchWideChar As Long, ByVal lpMultiByteStr As String, ByVal cchMultiByte As Long, ByVal lpDefaultChar As String, ByVal lpUsedDefaultChar As Long) As Long



'WinInet.DLL

Const INTERNET_OPEN_TYPE_PRECONFIG = 0
Const PRE_CONFIG_INTERNET_ACCESS = 0
Const INTERNET_INVALID_PORT_NUMBER = 0
Const INTERNET_FLAG_RELOAD = &H80000000

Public Declare Function InternetOpen Lib "wininet.dll" Alias _
    "InternetOpenA" (ByVal sAgent As String, ByVal lAccessType _
    As Long, ByVal sProxyName As String, ByVal sProxyBypass As _
    String, ByVal lFlags As Long) As Long

Public Declare Function InternetOpenUrl Lib "wininet.dll" Alias _
    "InternetOpenUrlA" (ByVal hOpen As Long, ByVal sUrl As String, _
    ByVal sHeaders As String, ByVal lLength As Long, ByVal lFlags _
    As Long, ByVal lContext As Long) As Long

Public Declare Function InternetCloseHandle Lib "wininet.dll" _
(ByVal hInet As Long) As Integer

Public Declare Function InternetReadFile Lib "wininet.dll" ( _
    ByVal hFile As Long, _
    ByVal sBuffer As String, _
    ByVal lNumBytesToRead As Long, _
    lNumberOfBytesRead As Long) _
    As Integer
    
Type VideoParams
    FileName As String
    pos As Long
    Status As Integer
    PosStr As String
    hWnd As Long
End Type

Public Player As Integer
Public PlayerType As String
Public PlayerStandardPath As String

'  
Public mpc_wp As WINDOWPLACEMENT
Public vi As VideoParams

Dim oldVideoFileName As String
Public StatusRequested As Boolean


Const MPC_PortNumber = 13579
Const MPC_Address = "http://localhost"
Const MPC_AddrString = "/status.html"

Const VLC_PortNumber = 8080
Const VLC_Address = "http://localhost"
Const VLC_AddrString = "/requests/status.xml"

Public PortNumber As Long
Public Address As String
Public AddrString As String


Public VideoPlayerPath As String
Public VideoPlayerEXE As String '  


'Player session WinInet handler
Public hPlayerNet As Long

Public Const MPC_QuickOpen = 968
Public Const MPC_Play = 887
Public Const MPC_Pause = 888
Public Const MPC_PlayPause = 889
Public Const MPC_Stop = 890
Public Const MPC_FrameForward = 891
Public Const MPC_FrameBack = 892
Public Const MPC_AlwaysOnTop = 884
Public Const MPC_ViewNormal = 829
Public Const MPC_SmallJumpForward = 900 '>Jump Forward (small)
Public Const MPC_SmallJumpBackward = 899 '>Jump Backward (small)
Public Const MPC_DecreaseRate = 894
Public Const MPC_IncreaseRate = 895

Sub SelectPlayer(Name As String)
Name = UCase(Name)
PlayerType = Name
Select Case Name
Case "MPC"
    Address = MPC_Address
    PortNumber = MPC_PortNumber
    AddrString = MPC_AddrString
    PlayerStandardPath = CorrectPath(App.path) + "MPC\mplayerc.exe"
    PlayerWindowName = "Media Player Classic"

Case "VLC"
    Address = VLC_Address
    PortNumber = VLC_PortNumber
    AddrString = VLC_AddrString
    PlayerStandardPath = CorrectPath(App.path) + "VLC\vlc.exe"
    PlayerWindowName = "  VLC"

Case Else
    Address = VLC_Address
    PortNumber = VLC_PortNumber
    AddrString = VLC_AddrString
End Select

End Sub

Sub StartInet()
hPlayerNet = InternetOpen("RealTimer", PRE_CONFIG_INTERNET_ACCESS, _
vbNullString, INTERNET_INVALID_PORT_NUMBER, 0)

'temp
SelectPlayer "VLC"
End Sub

Sub CloseInet()
Call InternetCloseHandle(hPlayerNet)
End Sub

Sub SearchPlayer()
' 
Dim buf As String
Dim k As Long
Dim ret As Long
cmd = 0

FindAPlayer.Show 1

If cmd = 1 Then
    'Player is found
    cmd = 0
    LoadPlayer
End If

'Put info into MPC ini...
'EnableWebServer = 1
'WebServerPort = 13579
'WebServerPrintDebugIfo = 0
'WebServerUseCompression = 1
'WebServerLocalhostOnly = 1
End Sub

Sub SetPlayerSettings()
    VideoPlayerPath = CorrectPath(XFilePath(VideoPlayerEXE))
Select Case PlayerType
Case "MPC"
    IniFile = VideoPlayerPath + "mplayerc.ini"
    WritePrivateProfileString "Settings", "EnableWebServer", "1", IniFile$
    WritePrivateProfileString "Settings", "WebServerPort", "13579", IniFile$
    WritePrivateProfileString "Settings", "WebServerPrintDebugIfo", "0", IniFile$
    WritePrivateProfileString "Settings", "OnTop", "1", IniFile$
End Select
End Sub

Sub StartPlayer()
Dim buf As String
If Dir(VideoPlayerEXE) <> "" And RTrim(VideoPlayerEXE) <> "" Then
    LoadPlayer
Else
    
    '    
    buf = PlayerStandardPath
    If Dir(buf) <> "" Then
        VideoPlayerEXE = buf
        LoadPlayer
    Else
        SearchPlayer
    End If
End If
End Sub

Sub LoadPlayer()
    SetPlayerSettings
    LittleWindow.CheckTimer.Enabled = False
    
    LittleWindow.Caption = GetRString("1211", " Gabest Media Player ...  -  RealTimer")
    
    Shell VideoPlayerEXE, vbNormalNoFocus
    SleepEx 500, 0
    LittleWindow.Caption = LittleWindowTitle
    LittleWindow.CheckTimer.Enabled = True
   
End Sub

Sub GetVideoStatus()
Dim buf As String

Dim hNet As Long
Dim hUrlFile As Long
Dim buffer As String
Dim BytesRead As Long
Dim bRead As Integer
    
On Local Error GoTo videostatuserror
  
If Player = 1 And hPlayerNet Then
    buf = Address + ":" + LTrim(Str(PortNumber)) + AddrString
    hUrlFile = InternetOpenUrl(hPlayerNet, buf, vbNullString, 0, INTERNET_FLAG_RELOAD, 0)
    buffer = String(4096, 0)
    bRead = InternetReadFile(hUrlFile, buffer, Len(buffer), BytesRead)
    Call InternetCloseHandle(hUrlFile)
    buffer = Left(buffer, BytesRead)
    Select Case PlayerType
    Case "MPC"
        MPC_RetrieveVideoParams buffer
    Case "VLC"
        VLC_RetrieveVideoParams buffer
    End Select
End If

StatusRequested = True
Exit Sub

videostatuserror:
Resume Next
End Sub

Function GetPlayerResponse() As Integer

Dim buf As String
Dim hNet As Long
Dim hUrlFile As Long
Dim buffer As String
Dim BytesRead As Long
Dim bRead As Integer

If hPlayerNet Then
    buf = Address + ":" + LTrim(Str(PortNumber)) + AddrString
    hUrlFile = InternetOpenUrl(hPlayerNet, buf, vbNullString, 0, INTERNET_FLAG_RELOAD, 0)
    buffer = String(4096, 0)
    bRead = InternetReadFile(hUrlFile, buffer, Len(buffer), BytesRead)
    Call InternetCloseHandle(hUrlFile)
    buffer = Left(buffer, BytesRead)
    Select Case PlayerType
    Case "MPC"
        MPC_RetrieveVideoParams buffer
    Case "VLC"
        VLC_RetrieveVideoParams buffer
    End Select
End If

End Function

Sub MPC_RetrieveVideoParams(buf As String)
'     ()
'     
'      
Dim FileName As String

'If Pause = True Then Exit Sub
'If Player = 0 Then Exit Sub
If buf = "" Then Exit Sub
If buf = "Error" Then Exit Sub

'  unicode    !!!
FileName = ConvertString(GetVideoParam(buf, 1), 65001, 0)
vi.Status = Val(GetVideoParam(buf, 2))
vi.pos = Val(GetVideoParam(buf, 3))
vi.PosStr = GetVideoParam(buf, 4)
vi.FileName = FileName

If oldVideoFileName <> vi.FileName Then
    If RTrim(FileName) = "Media Player Classic" Then
    Else
        AddExitRec
        AddAuxRec "Open", "", vi.FileName
    End If
    oldVideoFileName = vi.FileName
End If
End Sub

Sub VLC_RetrieveVideoParams(buf As String)
'     ()
'     
'      
Dim FileName As String

'If Pause = True Then Exit Sub
'If Player = 0 Then Exit Sub
If buf = "" Then Exit Sub
If buf = "Error" Then Exit Sub

'  unicode    !!!
FileName = ConvertString(GetVideoParam(buf, 1), 65001, 0)
vi.Status = Val(GetVideoParam(buf, 2))
vi.pos = Val(GetVideoParam(buf, 3))
vi.PosStr = GetVideoParam(buf, 4)
vi.FileName = FileName

If oldVideoFileName <> vi.FileName Then
    If RTrim(FileName) = "Media Player Classic" Then
    Else
        AddExitRec
        AddAuxRec "Open", "", vi.FileName
    End If
    oldVideoFileName = vi.FileName
End If
End Sub


Sub VideoCommand(command As Long)
Dim buf As String
Dim i As Integer
'send command to the video player
If Player = 1 And hPlayerNet Then
    Pause = True
    buf = Address + ":" + LTrim(Str(PortNumber)) + "/command.html?wm_command="
    buf = buf + LTrim(Str(command))
    hUrlFile = InternetOpenUrl(hPlayerNet, buf, vbNullString, 0, INTERNET_FLAG_RELOAD, 0)
    Call InternetCloseHandle(hUrlFile)
    StatusRequested = False
    Pause = False
End If
End Sub


Function GetPlayerWindow() As Boolean
   Dim ret As Long
   Dim hWnd As Long
   
   If RTrim(vi.FileName) <> "" Then hWnd = FindWindow(vbNullString, vi.FileName)
   If hWnd = 0 Then hWnd = FindWindow(vbNullString, PlayerWindowName)
   If hWnd = 0 And Player = 1 Then
       GetPlayerResponse
       If RTrim(vi.FileName) <> "" Then hWnd = FindWindow(vbNullString, vi.FileName)
   End If
   
   If hWnd <> 0 Then
        vi.hWnd = hWnd
        'ret = GetWindowPlacement(hWnd, mpc_wp)
        GetPlayerWindow = True
    Else
        GetPlayerWindow = False
    End If
End Function

Sub ShowPlayerWindow()
   Dim ret As Long
   
   If GetPlayerWindow = True Then
        ret = GetWindowPlacement(vi.hWnd, mpc_wp)
        'Debug.Print wp.rcNormalPosition.Bottom
        'If mpc_wp.showCmd = 2 Then
            'if minimized
            mpc_wp.showCmd = 1
            ret = SetWindowPlacement(vi.hWnd, mpc_wp)
        SetForegroundWindow vi.hWnd
        'End If
        'ret = SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, flags)
    End If
End Sub


Function GetVideoParam(text As String, num As Integer) As String
    Dim buf As String
    buf = Mid(text, 9)
    Dim k As Integer
    Dim oldk As Integer
    Dim t As Integer
    Dim i As Integer
    Dim w As String
    k = 0
    oldk = 1
    For t = 1 To num
        k = InStr(oldk + 1, buf$, ",")
        i = k + 1
        If k = 0 Then k = Len(buf$) + 1: i = k
        If k > oldk Then w$ = Mid$(buf$, oldk, k - oldk) Else w$ = ""
        oldk = i
    Next t
    w$ = RTrim(LTrim(w$))
    If Left(w$, 1) = "(" Then w$ = Mid(w$, 2)
    If Left(w$, 1) = "'" Then w$ = Mid(w$, 2)
    If Right(w$, 1) = ")" Then w$ = Left(w$, Len(w$) - 1)
    If Right(w$, 1) = "'" Then w$ = Left(w$, Len(w$) - 1)
    GetVideoParam = w$
End Function

' 
' utf-8    MultiByteToWideChar   0 (   MSDN)
Public Function ConvertString(ByVal strSrc As String, _
ByVal nFromCP As Long, _
ByVal nToCP As Long) As String
Dim nLen As Long
Dim strDst As String
Dim strRet As String
Dim nRet As Long

nLen = Len(strSrc)
strDst = String(nLen * 2, Chr(0))
strRet = String(nLen * 2, Chr(0))
nRet = MultiByteToWideChar(CLng(nFromCP), 0, strSrc, nLen, strDst, nLen)
nRet = WideCharToMultiByte(nToCP, 0, strDst, nRet, strRet, nLen * 2, ByVal 0, 0)
ConvertString = Left(strRet, nRet)
End Function

'  ,   ConvertString
Sub Unicode2text(text As String)
Dim buf As String
Dim c As String * 1
Dim i As Integer
Dim k As Integer

For i = 1 To Len(text)
    c = Mid(text, i, 1)
    'Debug.Print Asc(c)
    k = Asc(c)
    If k > 128 Then
        i = i + 1
        c = Mid(text, i, 1)
        'Debug.Print Chr(Asc(c) + 48)
        'Debug.Print Asc(c)
        'Debug.Print Asc("")
        If k = 208 Then buf = buf + Chr(Asc(c) + 48)
        If k = 209 Then buf = buf + Chr(Asc(c) + 112)
    Else
        buf = buf + c
    End If
Next i
text = buf
End Sub

